import java.io.*;
import java.net.*;

public class LPClient {
  public static void main(String[] args) throws IOException {
    
    Socket LPSocket = null;
    PrintWriter out = null;

    try {
      LPSocket = new Socket(args[0], 2223);
      out = new PrintWriter(LPSocket.getOutputStream(), true);
    } catch (UnknownHostException e) {
      System.err.println("Don't know about host: "+args[0]);
      System.exit(1);
    } catch (IOException e) {
      System.err.println("Couldn't get I/O for the connection to: "+args[0]);
      System.exit(1);
    }
    
    String userInput;
    
    BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
    while ((userInput = r.readLine()) != null) {
      out.println(userInput);
      System.out.println("Sent: " + userInput);
    }
    
    out.close();
    LPSocket.close();
  }
}

